/*
 * Decompiled with CFR 0.152.
 */
package net.minecraftforge.jarjar.util;

import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Supplier;

public class Lazy<T> {
    private final Object lock = new Object();
    private T value;
    private Boolean initialized;
    private final Supplier<T> provider;

    public static <T> Lazy<T> of() {
        return new Lazy<T>((Supplier)null);
    }

    public static <T> Lazy<T> of(T value) {
        return new Lazy<T>(value);
    }

    public static <T> Lazy<T> of(Supplier<T> provider) {
        return new Lazy<T>(provider);
    }

    private Lazy(T value) {
        this.value = value;
        this.initialized = true;
        this.provider = () -> value;
    }

    private Lazy(Supplier<T> provider) {
        this.value = null;
        this.initialized = false;
        this.provider = provider;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public T get() {
        Object object = this.lock;
        synchronized (object) {
            if (!this.initialized.booleanValue() && this.provider != null) {
                this.initialized = true;
                this.value = this.provider.get();
            }
            return this.value;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void ifPresent(Consumer<T> consumer) {
        Object object = this.lock;
        synchronized (object) {
            if (!this.initialized.booleanValue()) {
                return;
            }
            consumer.accept(this.value);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public <R> Lazy<R> map(Function<T, R> mapper) {
        Object object = this.lock;
        synchronized (object) {
            return Lazy.of(() -> mapper.apply(this.get()));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public T orElse(T elseValue) {
        Object object = this.lock;
        synchronized (object) {
            if (!this.initialized.booleanValue()) {
                return elseValue;
            }
            return this.value;
        }
    }
}

